/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.AddCardSubtypeAttachedEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class InnerDemon
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("all non-Demon creatures");

    public InnerDemon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2, Duration.WhileOnBattlefield));
        GainAbilityAttachedEffect effect = new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA);
        effect.setText(", has flying");
        ability.addEffect((Effect)effect);
        effect = new AddCardSubtypeAttachedEffect(SubType.DEMON, AttachmentType.AURA);
        effect.setText(", and is a Demon in addition to its other types");
        ability.addEffect((Effect)effect);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new BoostAllEffect(-2, -2, Duration.EndOfTurn, filter, false)));
    }

    private InnerDemon(InnerDemon card) {
        super((CardImpl)card);
    }

    public InnerDemon copy() {
        return new InnerDemon(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.DEMON.getPredicate()));
    }
}

