/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.awt.Color;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.hint.HintUtils;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.CherubaelToken;
import mage.players.Player;
import mage.watchers.common.CardsAmountDrawnThisTurnWatcher;

class InquisitorEisenhornReplacementEffect
extends ReplacementEffectImpl {
    InquisitorEisenhornReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "You may reveal the first card you draw each turn as you draw it. Whenever you reveal an instant or sorcery card this way, create Cherubael, a legendary 4/4 black Demon creature token with flying";
    }

    private InquisitorEisenhornReplacementEffect(InquisitorEisenhornReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public InquisitorEisenhornReplacementEffect copy() {
        return new InquisitorEisenhornReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        if (topCard.isInstantOrSorcery(game)) {
            new CherubaelToken().putOntoBattlefield(1, game, source);
        }
        controller.setTopCardRevealed(true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    String getAppliedMark(Game game, Ability source) {
        return source.getId() + "-applied-" + source.getControllerId() + "-" + game.getState().getTurnNum();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null && controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        CardsAmountDrawnThisTurnWatcher watcher = (CardsAmountDrawnThisTurnWatcher)game.getState().getWatcher(CardsAmountDrawnThisTurnWatcher.class);
        if (watcher != null && watcher.getAmountCardsDrawn(event.getPlayerId()) != 0) {
            return false;
        }
        String mark = this.getAppliedMark(game, source);
        if (game.getState().getValue(mark) != null) {
            return false;
        }
        game.getState().setValue(mark, (Object)true);
        String mes = topCard.getName() + ", " + (topCard.isInstantOrSorcery(game) ? HintUtils.prepareText((String)"you will create Cherubael", (Color)Color.green) : HintUtils.prepareText((String)"you won't create Cherubael", (Color)Color.red));
        return controller.chooseUse(Outcome.Benefit, "Reveal first drawn card (" + mes + ")?", source, game);
    }
}

