/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventAllDamageByAllPermanentsEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class InquisitorsSnareEffect
extends OneShotEffect {
    InquisitorsSnareEffect() {
        super(Outcome.Detriment);
        this.staticText = "Prevent all damage target attacking or blocking creature would deal this turn. If that creature is black or red, destroy it";
    }

    private InquisitorsSnareEffect(InquisitorsSnareEffect effect) {
        super((OneShotEffect)effect);
    }

    public InquisitorsSnareEffect copy() {
        return new InquisitorsSnareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new PermanentIdPredicate(targetCreature.getId()));
            game.addEffect((ContinuousEffect)new PreventAllDamageByAllPermanentsEffect((FilterPermanent)filter, Duration.EndOfTurn, false), source);
            if (targetCreature.getColor(game).isBlack() || targetCreature.getColor(game).isRed()) {
                return targetCreature.destroy(source, game, false);
            }
        }
        return false;
    }
}

