/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.FoodToken;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class InsatiableFrugivoreEffect
extends OneShotEffect {
    InsatiableFrugivoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a Food token, then you may exile three cards from your graveyard. If you do, repeat this process";
    }

    private InsatiableFrugivoreEffect(InsatiableFrugivoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public InsatiableFrugivoreEffect copy() {
        return new InsatiableFrugivoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean repeat;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        do {
            new FoodToken().putOntoBattlefield(1, game, source);
            ExileFromGraveCost cost = new ExileFromGraveCost(new TargetCardInYourGraveyard(3));
            boolean bl = repeat = cost.canPay(source, source, controller.getId(), game) && controller.chooseUse(Outcome.Exile, "Exile three cards from your graveyard?", source, game) && cost.pay(source, game, source, controller.getId(), false);
        } while (repeat && controller.canRespond());
        return true;
    }
}

