/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class InscriptionOfAbundanceEffect
extends OneShotEffect {
    InscriptionOfAbundanceEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player gains X life, where X is the greatest power among creatures they control";
    }

    private InscriptionOfAbundanceEffect(InscriptionOfAbundanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public InscriptionOfAbundanceEffect copy() {
        return new InscriptionOfAbundanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        int maxPower = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getFirstTarget(), source, game).stream().filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
        if (maxPower > 0) {
            player.gainLife(maxPower, game, source);
            return true;
        }
        return false;
    }
}

