/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.abilities.keyword.KickerWithAnyNumberModesAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponent;

public final class InscriptionOfRuin
extends CardImpl {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 2 or less from your graveyard");
    private static final FilterPermanent filter2 = new FilterCreaturePermanent("creature with mana value 3 or less");

    public InscriptionOfRuin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{B}");
        this.addAbility((Ability)new KickerWithAnyNumberModesAbility("{2}{B}{B}"));
        this.getSpellAbility().getModes().setChooseText("choose one. If this spell was kicked, choose any number instead.");
        this.getSpellAbility().addEffect((Effect)new DiscardTargetEffect(2));
        this.getSpellAbility().addTarget((Target)new TargetOpponent());
        Mode mode = new Mode((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        mode.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent(filter2));
        this.getSpellAbility().addMode(mode);
    }

    private InscriptionOfRuin(InscriptionOfRuin card) {
        super((CardImpl)card);
    }

    public InscriptionOfRuin copy() {
        return new InscriptionOfRuin(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
        filter2.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

