/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.MayLookAtTargetCardEffect;
import mage.cards.Card;
import mage.cards.i.IntetTheDreamerAsThoughEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class IntetTheDreamerExileEffect
extends OneShotEffect {
    IntetTheDreamerExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library face down. You may look at that card for as long as it remains exiled. You may play that card without paying its mana cost for as long as Intet remains on the battlefield";
    }

    private IntetTheDreamerExileEffect(IntetTheDreamerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        MageObject sourceObject = source.getSourceObject(game);
        if (card == null || sourceObject == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game));
        String exileName = sourceObject.getIdName() + " (" + sourceObject.getZoneChangeCounter(game) + ")";
        card.setFaceDown(true, game);
        if (controller.moveCardsToExile(card, source, game, false, exileId, exileName)) {
            card.setFaceDown(true, game);
            IntetTheDreamerAsThoughEffect effect = new IntetTheDreamerAsThoughEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game.getState().getZoneChangeCounter(card.getId())));
            game.getState().addEffect((ContinuousEffect)effect, source);
            effect = new MayLookAtTargetCardEffect(controller.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    public IntetTheDreamerExileEffect copy() {
        return new IntetTheDreamerExileEffect(this);
    }
}

