/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class IntoTheFireEffect
extends OneShotEffect {
    IntoTheFireEffect() {
        super(Outcome.Benefit);
        this.staticText = "put any number of cards from your hand on the bottom of your library, then draw that many cards plus one";
    }

    private IntoTheFireEffect(IntoTheFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntoTheFireEffect copy() {
        return new IntoTheFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand targetCard = new TargetCardInHand(0, Integer.MAX_VALUE, StaticFilters.FILTER_CARD_CARDS);
        player.choose(this.outcome, player.getHand(), (TargetCard)targetCard, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCard.getTargets());
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        player.drawCards(cards.size() + 1, source, game);
        return true;
    }
}

