/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class IntrepidPaleontologistPlayEffect
extends AsThoughEffectImpl {
    IntrepidPaleontologistPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may cast Dinosaur creature spells from among cards you own exiled with {this}. If you cast a spell this way, that creature enters the battlefield with a finality counter on it.";
    }

    private IntrepidPaleontologistPlayEffect(IntrepidPaleontologistPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IntrepidPaleontologistPlayEffect copy() {
        return new IntrepidPaleontologistPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        if (playerId.equals(source.getControllerId())) {
            Card card = game.getCard(objectId);
            MageObject sourceObject = game.getObject(source);
            if (card != null && sourceObject != null && affectedAbility instanceof SpellAbility) {
                Card characteristics = ((SpellAbility)affectedAbility).getCharacteristics(game);
                if (card.getOwnerId().equals(playerId) && characteristics.isCreature(game) && characteristics.hasSubtype(SubType.DINOSAUR, game)) {
                    UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game));
                    ExileZone exileZone = game.getState().getExile().getExileZone(exileId);
                    return exileZone != null && exileZone.contains((Object)objectId);
                }
            }
        }
        return false;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return false;
    }
}

