/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InvaderParasiteTriggeredAbility
extends TriggeredAbilityImpl {
    InvaderParasiteTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2));
    }

    private InvaderParasiteTriggeredAbility(InvaderParasiteTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public InvaderParasiteTriggeredAbility copy() {
        return new InvaderParasiteTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId())) {
            Card imprintedCard;
            Permanent targetPermanent = game.getPermanent(event.getTargetId());
            Permanent sourcePermanent = game.getPermanent(this.getSourceId());
            if (targetPermanent != null && sourcePermanent != null && !sourcePermanent.getImprinted().isEmpty() && (imprintedCard = game.getCard((UUID)sourcePermanent.getImprinted().get(0))) != null && targetPermanent.getName().equals(imprintedCard.getName())) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a land with the same name as the exiled card enters the battlefield under an opponent's control, {this} deals 2 damage to that player.";
    }
}

