/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.WishEffect;
import mage.abilities.effects.common.search.SearchLibraryGraveyardPutInHandEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class InvasionOfArcaviosEffect
extends OneShotEffect {
    InvasionOfArcaviosEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library, graveyard, and/or outside the game for an instant or sorcery card you own, reveal it, and put it into your hand. If you search your library this way, shuffle";
    }

    private InvasionOfArcaviosEffect(InvasionOfArcaviosEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfArcaviosEffect copy() {
        return new InvasionOfArcaviosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Look outside the game?", source, game) && new WishEffect((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY).apply(game, source)) {
            return true;
        }
        return new SearchLibraryGraveyardPutInHandEffect((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, false).apply(game, source);
    }
}

