/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InvasionOfKaldheimEffect
extends OneShotEffect {
    InvasionOfKaldheimEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all cards from your hand, then draw that many cards. Until the end of your next turn, you may play cards exiled this way";
    }

    private InvasionOfKaldheimEffect(InvasionOfKaldheimEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfKaldheimEffect copy() {
        return new InvasionOfKaldheimEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)player.getHand());
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.drawCards(cards.size(), source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false);
        }
        return true;
    }
}

