/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.cards.i.InvasionOfTheGiantsWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.util.CardUtil;

class InvasionOfTheGiantsEffect
extends CostModificationEffectImpl {
    private int spellsCast;

    InvasionOfTheGiantsEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next Giant spell you cast this turn costs {2} less to cast";
    }

    private InvasionOfTheGiantsEffect(InvasionOfTheGiantsEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        InvasionOfTheGiantsWatcher watcher = (InvasionOfTheGiantsWatcher)game.getState().getWatcher(InvasionOfTheGiantsWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        InvasionOfTheGiantsWatcher watcher = (InvasionOfTheGiantsWatcher)game.getState().getWatcher(InvasionOfTheGiantsWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (watcher.getCount(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null && spellCard.hasSubtype(SubType.GIANT, game);
    }

    public InvasionOfTheGiantsEffect copy() {
        return new InvasionOfTheGiantsEffect(this);
    }
}

