/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.DeliriumCondition;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetSpell;

class InvasiveSurgeryEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    InvasiveSurgeryEffect() {
        super(true, "that spell's controller", "all cards with the same name as that spell");
        this.staticText = "Counter target sorcery spell.<br><br><i>Delirium</i> &mdash; If there are four or more card types among cards in your graveyard, search the graveyard, hand, and library of that spell's controller for any number of cards with the same name as that spell, exile those cards, then that player shuffles";
    }

    private InvasiveSurgeryEffect(InvasiveSurgeryEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public InvasiveSurgeryEffect copy() {
        return new InvasiveSurgeryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        String cardName = "";
        UUID spellController = null;
        if (source.getTargets().get(0) instanceof TargetSpell) {
            UUID objectId = source.getFirstTarget();
            StackObject stackObject = game.getStack().getStackObject(objectId);
            if (stackObject != null) {
                MageObject targetObject = game.getObject(stackObject.getSourceId());
                if (targetObject instanceof Card) {
                    cardName = targetObject.getName();
                }
                spellController = stackObject.getControllerId();
                game.getStack().counter(objectId, source, game);
            }
        }
        if (!DeliriumCondition.instance.apply(game, source)) {
            return true;
        }
        return this.applySearchAndExile(game, source, cardName, spellController);
    }
}

