/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class InverterOfTruthEffect
extends OneShotEffect {
    InverterOfTruthEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all cards from your library face down, then shuffle all cards from your graveyard into your library";
    }

    private InverterOfTruthEffect(InverterOfTruthEffect effect) {
        super((OneShotEffect)effect);
    }

    public InverterOfTruthEffect copy() {
        return new InverterOfTruthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getCards(game));
        cards.getCards(game).stream().filter(Objects::nonNull).forEach(card -> card.setFaceDown(true, game));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.shuffleCardsToLibrary((Cards)player.getGraveyard(), game, source);
        return true;
    }
}

