/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class IonaShieldOfEmeriaReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    IonaShieldOfEmeriaReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells of the chosen color";
    }

    private IonaShieldOfEmeriaReplacementEffect(IonaShieldOfEmeriaReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        ObjectColor chosenColor = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        MageObject mageObject = game.getObject(source);
        if (mageObject != null && chosenColor != null) {
            return "You can't cast " + chosenColor.toString() + " spells (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            ObjectColor chosenColor = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
            Card card = game.getCard(event.getSourceId());
            if (chosenColor != null && card != null && card.getColor(game).contains(chosenColor)) {
                return true;
            }
        }
        return false;
    }

    public IonaShieldOfEmeriaReplacementEffect copy() {
        return new IonaShieldOfEmeriaReplacementEffect(this);
    }
}

