/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.common.combat.CantBlockAttachedEffect;
import mage.constants.AttachmentType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IronclawCurseEffect
extends CantBlockAttachedEffect {
    IronclawCurseEffect() {
        super(AttachmentType.AURA);
        this.staticText = "Enchanted creature can't block creatures with power equal to or greater than the enchanted creature's toughness";
    }

    private IronclawCurseEffect(IronclawCurseEffect effect) {
        super((CantBlockAttachedEffect)effect);
    }

    public IronclawCurseEffect copy() {
        return new IronclawCurseEffect(this);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanent(enchantment.getAttachedTo());
        if (enchantment.getAttachedTo() != null) {
            return attacker.getPower().getValue() < enchantedCreature.getToughness().getValue();
        }
        return true;
    }
}

