/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IslandOfWakWakEffect
extends OneShotEffect {
    IslandOfWakWakEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target creature with flying has base power 0 until end of turn.";
    }

    private IslandOfWakWakEffect(IslandOfWakWakEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            int toughness = targetCreature.getToughness().getModifiedBaseValue();
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessTargetEffect(null, (DynamicValue)StaticValue.get((int)toughness), Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public IslandOfWakWakEffect copy() {
        return new IslandOfWakWakEffect(this);
    }
}

