/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class IxalansBindingReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    IxalansBindingReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells with the same name as the exiled card";
    }

    private IxalansBindingReplacementEffect(IxalansBindingReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID exileZone;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (sourcePermanent != null && card != null && (exileZone = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC())) != null) {
            ExileZone exile = game.getExile().getExileZone(exileZone);
            if (exile == null && (exileZone = CardUtil.getCardExileZoneId((Game)game, (Ability)source)) != null) {
                exile = game.getExile().getExileZone(exileZone);
            }
            if (exile != null) {
                for (Card e : exile.getCards(game)) {
                    if (!CardUtil.haveSameNames((MageObject)e, (MageObject)card)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public IxalansBindingReplacementEffect copy() {
        return new IxalansBindingReplacementEffect(this);
    }
}

