/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class JaceArchitectOfThoughtEffect3
extends OneShotEffect {
    public JaceArchitectOfThoughtEffect3() {
        super(Outcome.PlayForFree);
        this.staticText = "For each player, search that player's library for a nonland card and exile it, then that player shuffles. You may cast those cards without paying their mana costs";
    }

    private JaceArchitectOfThoughtEffect3(JaceArchitectOfThoughtEffect3 effect) {
        super((OneShotEffect)effect);
    }

    public JaceArchitectOfThoughtEffect3 copy() {
        return new JaceArchitectOfThoughtEffect3(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.chooseUse(Outcome.Benefit, "Look at all players' libraries before card select?", source, game)) {
            game.informPlayers(controller.getLogName() + " is looking at all players' libraries.");
            controller.lookAtAllLibraries(source, game);
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
            controller.searchLibrary(target, source, game, playerId);
            Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
            if (card == null) continue;
            cards.add(card);
            controller.moveCards(card, Zone.EXILED, source, game);
            player.shuffleLibrary(source, game);
        }
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

