/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JaceMirrorMageCopyEffect
extends OneShotEffect {
    JaceMirrorMageCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of {this}, except it's not legendary and its starting loyalty is 1.";
    }

    private JaceMirrorMageCopyEffect(JaceMirrorMageCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaceMirrorMageCopyEffect copy() {
        return new JaceMirrorMageCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1);
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        effect.setIsntLegendary(true);
        effect.setStartingLoyalty(1);
        return effect.apply(game, source);
    }
}

