/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JaceMirrorMageDrawEffect
extends OneShotEffect {
    JaceMirrorMageDrawEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card and reveal it. Remove a number of loyalty counters equal to that card's mana value from {this}";
    }

    private JaceMirrorMageDrawEffect(JaceMirrorMageDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaceMirrorMageDrawEffect copy() {
        return new JaceMirrorMageDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (controller.drawCards(1, source, game) != 1) {
            return true;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card == null || card.getManaValue() == 0) {
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return true;
        }
        permanent.removeCounters(CounterType.LOYALTY.createInstance(card.getManaValue()), source, game);
        return true;
    }
}

