/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterSource;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetSource;

class JadeMonolithRedirectionEffect
extends ReplacementEffectImpl {
    private final TargetSource targetSource;

    public JadeMonolithRedirectionEffect() {
        super(Duration.OneUse, Outcome.RedirectDamage);
        this.staticText = "The next time a source of your choice would deal damage to target creature this turn, that source deals that damage to you instead";
        this.targetSource = new TargetSource(new FilterSource("source of your choice"));
    }

    private JadeMonolithRedirectionEffect(JadeMonolithRedirectionEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.targetSource = effect.targetSource.copy();
    }

    public JadeMonolithRedirectionEffect copy() {
        return new JadeMonolithRedirectionEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null && targetCreature != null && sourceObject != null) {
            controller.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            StringBuilder sb = new StringBuilder(sourceObject.getLogName());
            sb.append(": ").append(damageEvent.getAmount()).append(" damage redirected from ").append(targetCreature.getLogName());
            sb.append(" to ").append(controller.getLogName());
            game.informPlayers(sb.toString());
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(this.targetSource.getFirstTarget()) && event.getTargetId().equals(source.getFirstTarget());
    }
}

