/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class JanglingAutomatonEffect
extends OneShotEffect {
    public JanglingAutomatonEffect() {
        super(Outcome.Untap);
        this.staticText = "untap all creatures defending player controls";
    }

    private JanglingAutomatonEffect(JanglingAutomatonEffect effect) {
        super((OneShotEffect)effect);
    }

    public JanglingAutomatonEffect copy() {
        return new JanglingAutomatonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId = game.getCombat().getDefendingPlayerId(source.getSourceId(), game);
        if (defenderId != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(defenderId));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }
}

