/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.j.JarJarBinksGainControlSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JarJarBinksEffect
extends OneShotEffect {
    JarJarBinksEffect() {
        super(Outcome.GainControl);
        this.staticText = "target opponent gains control of it";
    }

    private JarJarBinksEffect(JarJarBinksEffect effect) {
        super((OneShotEffect)effect);
    }

    public JarJarBinksEffect copy() {
        return new JarJarBinksEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent jarJar = source.getSourcePermanentIfItStillExists(game);
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && jarJar != null && opponent != null) {
            JarJarBinksGainControlSourceEffect effect = new JarJarBinksGainControlSourceEffect();
            effect.setTargetPointer(this.getTargetPointer().copy());
            game.addEffect((ContinuousEffect)effect, source);
            game.informPlayers(jarJar.getName() + " is now controlled by " + opponent.getLogName());
            return true;
        }
        return false;
    }
}

