/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class JaredCarthalionBoostEffect
extends OneShotEffect {
    JaredCarthalionBoostEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Choose up to two target creatures. For each of them, put a number of +1/+1 counters on it equal to the number of colors it is.";
    }

    private JaredCarthalionBoostEffect(JaredCarthalionBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaredCarthalionBoostEffect copy() {
        return new JaredCarthalionBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent creature = game.getPermanent(targetId);
            if (creature == null || creature.getColor().getColorCount() == 0) continue;
            Counter counter = CounterType.P1P1.createInstance(creature.getColor().getColorCount());
            creature.addCounters(counter, source, game);
        }
        return true;
    }
}

