/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.HumanToken;
import mage.game.permanent.token.Token;

class JerrenCorruptedBishopTriggeredAbility
extends TriggeredAbilityImpl {
    JerrenCorruptedBishopTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeSourceControllerEffect(1));
        this.addEffect((Effect)new CreateTokenEffect((Token)new HumanToken()));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private JerrenCorruptedBishopTriggeredAbility(JerrenCorruptedBishopTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public JerrenCorruptedBishopTriggeredAbility copy() {
        return new JerrenCorruptedBishopTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return event.getTargetId().equals(this.getSourceId());
            }
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                return zEvent.isDiesEvent() && zEvent.getTarget() != null && !zEvent.getTarget().getId().equals(this.getSourceId()) && zEvent.getTarget().isControlledBy(this.getControllerId()) && !(zEvent.getTarget() instanceof PermanentToken) && zEvent.getTarget().hasSubtype(SubType.HUMAN, game);
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} enters or another nontoken Human you control dies, you lose 1 life and create a 1/1 white Human creature token.";
    }
}

