/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class JeskaThriceRebornEffect
extends ReplacementEffectImpl {
    JeskaThriceRebornEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Damage);
        this.staticText = "choose target creature. Until your next turn, if that creature would deal combat damage to one of your opponents, it deals triple that damage to that player instead";
    }

    private JeskaThriceRebornEffect(JeskaThriceRebornEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public JeskaThriceRebornEffect copy() {
        return new JeskaThriceRebornEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!((DamagePlayerEvent)event).isCombatDamage() || !event.getSourceId().equals(this.getTargetPointer().getFirst(game, source))) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.hasOpponent(event.getTargetId(), game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)3));
        return false;
    }
}

