/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JeskaiInfiltratorEffect
extends OneShotEffect {
    JeskaiInfiltratorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile it and the top card of your library in a face-down pile, shuffle that pile, then manifest those cards";
    }

    private JeskaiInfiltratorEffect(JeskaiInfiltratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public JeskaiInfiltratorEffect copy() {
        return new JeskaiInfiltratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList cardsToManifest;
        Card topCard;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileId = UUID.randomUUID();
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            controller.moveCardsToExile((Card)sourcePermanent, source, game, false, exileId, "");
        }
        if ((topCard = controller.getLibrary().getFromTop(game)) != null) {
            controller.moveCardsToExile(topCard, source, game, false, exileId, "");
        }
        if ((cardsToManifest = new ArrayList(game.getExile().getExileZone(exileId).getCards(game))).isEmpty()) {
            return false;
        }
        for (Card card : cardsToManifest) {
            card.setFaceDown(true, game);
        }
        Collections.shuffle(cardsToManifest);
        game.informPlayers(controller.getLogName() + " shuffles the face-down pile");
        game.processAction();
        ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)controller, new LinkedHashSet(cardsToManifest));
        return true;
    }
}

