/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class JhoiraAgelessInnovatorEffect
extends OneShotEffect {
    JhoiraAgelessInnovatorEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = ", then you may put an artifact card with mana value X or less from your hand onto the battlefield, where X is the number of ingenuity counters on Jhoira.";
    }

    private JhoiraAgelessInnovatorEffect(JhoiraAgelessInnovatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public JhoiraAgelessInnovatorEffect copy() {
        return new JhoiraAgelessInnovatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return false;
        }
        int numCounters = sourcePermanent.getCounters(game).getCount(CounterType.INGENUITY);
        FilterArtifactCard filter = new FilterArtifactCard("artifact card with mana value " + numCounters + " or less from your hand");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, numCounters + 1));
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (!target.canChoose(controller.getId(), source, game) || !controller.chooseUse(this.outcome, "Put an artifact with mana value " + numCounters + " or less into play?", source, game)) {
            return false;
        }
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

