/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.CatHasteToken;
import mage.game.permanent.token.DogVigilanceToken;
import mage.players.Player;

class JinnieFayJetmirsSecondEffect
extends ReplacementEffectImpl {
    JinnieFayJetmirsSecondEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false);
        this.staticText = "if you would create one or more tokens, you may instead create that many 2/2 green Cat creature tokens with haste or that many 3/1 green Dog creature tokens with vigilance";
    }

    private JinnieFayJetmirsSecondEffect(JinnieFayJetmirsSecondEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public JinnieFayJetmirsSecondEffect copy() {
        return new JinnieFayJetmirsSecondEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
        Player player = game.getPlayer(source.getControllerId());
        int amount = tokenEvent.getTokens().values().stream().mapToInt(x -> x).sum();
        if (player == null || amount < 1 || !player.chooseUse(this.outcome, "Replace this token event?", source, game)) {
            return false;
        }
        CatHasteToken token = player.chooseUse(this.outcome, "Choose 2/2 Cat or 3/1 Dog", null, "Cat", "Dog", source, game) ? new CatHasteToken() : new DogVigilanceToken();
        tokenEvent.getTokens().clear();
        tokenEvent.getTokens().put(token, amount);
        return false;
    }
}

