/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.HistoricPredicate;
import mage.game.Game;
import mage.players.Player;

class JoGrantEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("historic card");

    JoGrantEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each historic card in your hand has cycling {2}{W}";
    }

    private JoGrantEffect(JoGrantEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public JoGrantEffect copy() {
        return new JoGrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getHand().getCards(filter, game)) {
            game.getState().addOtherAbility(card, (Ability)new CyclingAbility((Cost)new ManaCostsImpl("{2}{W}")));
        }
        return true;
    }

    static {
        filter.add((Predicate)HistoricPredicate.instance);
    }
}

