/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Set;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JoleneThePlunderQueenTriggeredAbility
extends TriggeredAbilityImpl {
    JoleneThePlunderQueenTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenTargetEffect((Token)new TreasureToken(), (DynamicValue)StaticValue.get((int)1)), false);
    }

    private JoleneThePlunderQueenTriggeredAbility(JoleneThePlunderQueenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public JoleneThePlunderQueenTriggeredAbility copy() {
        return new JoleneThePlunderQueenTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Combat combat = game.getCombat();
        UUID joleneController = game.getControllerId(this.sourceId);
        Set joleneOpponents = game.getOpponents(joleneController);
        if (combat.getAttackers().stream().noneMatch(attackerId -> {
            UUID defenderId = combat.getDefenderId(attackerId);
            return joleneOpponents.contains(defenderId);
        })) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }

    public String getRule() {
        return "Whenever a player attacks one or more of your opponents, that attacking player creates a Treasure token.";
    }
}

