/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JolraelVoiceOfZhalfirEffect
extends OneShotEffect {
    JolraelVoiceOfZhalfirEffect() {
        super(Outcome.Benefit);
        this.staticText = "up to one target land you control becomes an X/X green and blue Bird creature with flying and haste until end of turn, where X is the number of cards in your hand. It's still a land";
    }

    private JolraelVoiceOfZhalfirEffect(JolraelVoiceOfZhalfirEffect effect) {
        super((OneShotEffect)effect);
    }

    public JolraelVoiceOfZhalfirEffect copy() {
        return new JolraelVoiceOfZhalfirEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = Optional.of(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getHand).map(Set::size).orElse(0);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new BecomesCreatureTargetEffect((Token)new CreatureToken(count, count, "", new SubType[]{SubType.BIRD}).withAbility((Ability)FlyingAbility.getInstance()).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

