/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JovialEvilEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    JovialEvilEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target opponent, where X is twice the number of white creatures that player controls";
    }

    private JovialEvilEffect(JovialEvilEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent != null) {
            int amount = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, opponent.getId(), game)) {
                ++amount;
            }
            if (amount > 0) {
                opponent.damage(amount * 2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public JovialEvilEffect copy() {
        return new JovialEvilEffect(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

