/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class JukaiLiberatorEffect
extends OneShotEffect {
    JukaiLiberatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose land or nonland. Seek a permanent card of the chosen kind.";
    }

    private JukaiLiberatorEffect(JukaiLiberatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public JukaiLiberatorEffect copy() {
        return new JukaiLiberatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean land = player.chooseUse(Outcome.Neutral, "Choose land or nonland", null, "Land", "Nonland", source, game);
        if (land) {
            player.seekCard((FilterCard)StaticFilters.FILTER_CARD_LAND, source, game);
        } else {
            player.seekCard((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, source, game);
        }
        return true;
    }
}

