/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JumboImpRemoveCountersEffect
extends OneShotEffect {
    JumboImpRemoveCountersEffect() {
        super(Outcome.Detriment);
        this.staticText = "roll a six-sided die and remove a number of +1/+1 counters on {this} equal to the result";
    }

    private JumboImpRemoveCountersEffect(JumboImpRemoveCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public JumboImpRemoveCountersEffect copy() {
        return new JumboImpRemoveCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            permanent.removeCounters(CounterType.P1P1.createInstance(amount), source, game);
            return true;
        }
        return false;
    }
}

