/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CreaturesYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.CreaturesYouControlHint;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

public final class JunkyoBell
extends CardImpl {
    public JunkyoBell(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}");
        BeginningOfUpkeepTriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility((Effect)new BoostTargetEffect((DynamicValue)CreaturesYouControlCount.PLURAL, (DynamicValue)CreaturesYouControlCount.PLURAL, Duration.EndOfTurn), true);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        ability.addEffect((Effect)new JunkyoBellSacrificeEffect());
        ability.addHint((Hint)CreaturesYouControlHint.instance);
        this.addAbility((Ability)ability);
    }

    private JunkyoBell(JunkyoBell card) {
        super((CardImpl)card);
    }

    public JunkyoBell copy() {
        return new JunkyoBell(this);
    }

    private static class JunkyoBellSacrificeEffect
    extends OneShotEffect {
        public JunkyoBellSacrificeEffect() {
            super(Outcome.Sacrifice);
            this.staticText = "If you do, sacrifice that creature at the beginning of the next end step";
        }

        private JunkyoBellSacrificeEffect(JunkyoBellSacrificeEffect effect) {
            super((OneShotEffect)effect);
        }

        public JunkyoBellSacrificeEffect copy() {
            return new JunkyoBellSacrificeEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent creature = game.getPermanent(source.getFirstTarget());
            if (creature != null) {
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice boosted " + creature.getName(), source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                return true;
            }
            return false;
        }
    }
}

