/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class KaaliaZenithSeekerEffect
extends OneShotEffect {
    KaaliaZenithSeekerEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may reveal an Angel card, a Demon card, and/or a Dragon card from among them and put them into your hand. Put the rest on the bottom of your library in a random order.";
    }

    private KaaliaZenithSeekerEffect(KaaliaZenithSeekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaaliaZenithSeekerEffect copy() {
        return new KaaliaZenithSeekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        CardsImpl toHand = new CardsImpl();
        for (CreatureFinder creatureFinder : CreatureFinder.values()) {
            TargetCard targetCard = creatureFinder.getTarget();
            if (!player.choose(this.outcome, (Cards)cards, targetCard, source, game)) continue;
            toHand.addAll((Collection)targetCard.getTargets());
        }
        cards.removeAll((Collection)toHand);
        player.revealCards(source, (Cards)toHand, game);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    private static enum CreatureFinder {
        ANGEL(SubType.ANGEL),
        DEMON(SubType.DEMON),
        DRAGON(SubType.DRAGON);

        private final FilterCard filterCard;

        private CreatureFinder(SubType subType) {
            this.filterCard = new FilterCard("a " + subType.toString() + " card");
            this.filterCard.add((Predicate)subType.getPredicate());
        }

        private TargetCard getTarget() {
            return new TargetCardInLibrary(0, 1, this.filterCard);
        }
    }
}

