/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KaboomEffect
extends OneShotEffect {
    KaboomEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose any number of target players or planeswalkers. For each of them, reveal cards from the top of your library until you reveal a nonland card, {this} deals damage equal to that card's mana value to that player or planeswalker, then you put the revealed cards on the bottom of your library in any order.";
    }

    private KaboomEffect(KaboomEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaboomEffect copy() {
        return new KaboomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            CardsImpl toReveal = new CardsImpl();
            Card nonland = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (card.isLand(game)) continue;
                nonland = card;
                break;
            }
            controller.revealCards(source, (Cards)toReveal, game);
            if (nonland != null) {
                Permanent planeswalker = game.getPermanent(targetId);
                if (planeswalker != null) {
                    planeswalker.damage(nonland.getManaValue(), source, game);
                } else {
                    Player targetPlayer = game.getPlayer(targetId);
                    if (targetPlayer != null) {
                        targetPlayer.damage(nonland.getManaValue(), source, game);
                    }
                }
            }
            controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, true);
        }
        return true;
    }
}

