/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class KaervekThePunisherEffect
extends OneShotEffect {
    KaervekThePunisherEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target black card from your graveyard and copy it. You may cast the copy. If you do, you lose 2 life";
    }

    private KaervekThePunisherEffect(KaervekThePunisherEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaervekThePunisherEffect copy() {
        return new KaervekThePunisherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null) {
            return false;
        }
        card.moveToExile(null, "", source, game);
        Card copiedCard = game.copyCard(card, source, source.getControllerId());
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        SpellAbility spellAbility = controller.chooseAbilityForCast(copiedCard, game, false);
        if (controller.cast(spellAbility, game, false, new ApprovingObject(source, game))) {
            controller.loseLife(2, game, source, false);
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }
}

