/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KainTraitorousDragoonEffect
extends OneShotEffect {
    KainTraitorousDragoonEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player gains control of {this}. If they do, you draw that many cards, create that many tapped Treasure tokens, then lose that much life";
    }

    private KainTraitorousDragoonEffect(KainTraitorousDragoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public KainTraitorousDragoonEffect copy() {
        return new KainTraitorousDragoonEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null) return false;
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, player.getId()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.processAction();
        if (!permanent.isControlledBy(player.getId())) {
            return false;
        }
        int amount = (Integer)this.getValue("damage");
        if (amount <= 0) return false;
        if (Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(controller -> {
            controller.drawCards(amount, source, game);
            new TreasureToken().putOntoBattlefield(amount, game, source, controller.getId(), true, false);
            controller.loseLife(amount, game, source, false);
            return true;
        }).orElse(false) == false) return false;
        return true;
    }
}

