/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KarlovWatchdogEffect
extends ContinuousRuleModifyingEffectImpl {
    KarlovWatchdogEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Permanents your opponents control can't be turned face up during your turn";
    }

    private KarlovWatchdogEffect(KarlovWatchdogEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public KarlovWatchdogEffect copy() {
        return new KarlovWatchdogEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TURN_FACE_UP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && game.isActivePlayer(source.getControllerId()) && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId());
    }
}

