/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class KarmaDamageTargetEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledLandPermanent("Swamps");

    public KarmaDamageTargetEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to that player equal to the number of Swamps they control";
    }

    private KarmaDamageTargetEffect(KarmaDamageTargetEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, this.getTargetPointer().getFirst(game, source), game).size();
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public KarmaDamageTargetEffect copy() {
        return new KarmaDamageTargetEffect(this);
    }

    static {
        filter.add((Predicate)SubType.SWAMP.getPredicate());
    }
}

