/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.k.KarnLiberatedDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.GameImpl;
import mage.players.Player;
import mage.util.CardUtil;

class KarnLiberatedEffect
extends OneShotEffect {
    private UUID exileId;

    public KarnLiberatedEffect() {
        super(Outcome.ExtraTurn);
        this.staticText = "Restart the game, leaving in exile all non-Aura permanent cards exiled with {this}. Then put those cards onto the battlefield under your control";
    }

    private KarnLiberatedEffect(KarnLiberatedEffect effect) {
        super((OneShotEffect)effect);
        this.exileId = effect.exileId;
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        ArrayList<Card> keepExiled = new ArrayList<Card>();
        for (ExileZone zone : game.getExile().getExileZones()) {
            this.exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
            if (!zone.getId().equals(this.exileId)) continue;
            for (Card card : zone.getCards(game)) {
                if (card.hasSubtype(SubType.AURA, game) || !card.isPermanent(game)) continue;
                keepExiled.add(card);
            }
        }
        game.getState().clearOnGameRestart();
        ((GameImpl)game).initGameDefaultWatchers();
        for (Card card : game.getCards()) {
            game.getState().addCard(card);
        }
        for (Player player : game.getPlayers().values()) {
            if (!player.canRespond()) continue;
            player.init(game);
            player.useDeck(player.getMatchPlayer().getDeck(), game);
            ((GameImpl)game).initPlayerDefaultWatchers(player.getId());
        }
        for (Card card : keepExiled) {
            game.getState().setZone(card.getId(), Zone.EXILED);
            game.getExile().add(this.exileId, sourceObject.getIdName(), card);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new KarnLiberatedDelayedTriggeredAbility(this.exileId), source);
        game.setStartingPlayerId(source.getControllerId());
        game.start(null);
        return true;
    }

    public KarnLiberatedEffect copy() {
        return new KarnLiberatedEffect(this);
    }
}

