/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.ManaUtil;

class KarnLivingLegacyEffect
extends OneShotEffect {
    KarnLivingLegacyEffect() {
        super(Outcome.Benefit);
        this.staticText = "pay any amount of mana. Look at that many cards from the top of your library, then put one of those cards into your hand and the rest on the bottom of your library in a random order";
    }

    private KarnLivingLegacyEffect(KarnLivingLegacyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KarnLivingLegacyEffect copy() {
        return new KarnLivingLegacyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getLibrary().size() < 1) {
            return false;
        }
        int amount = ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Karn, Living Legacy", (Player)player, (Ability)source, (Game)game);
        if (amount < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, amount));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(StaticFilters.FILTER_CARD);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = cards.get(target.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        cards.remove(card);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

