/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class KarnPlayerExileEffect
extends OneShotEffect {
    KarnPlayerExileEffect() {
        super(Outcome.Exile);
        this.staticText = "target player exiles a card from their hand.";
    }

    private KarnPlayerExileEffect(KarnPlayerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand();
        if (target.canChoose(player.getId(), source, game) && target.chooseTarget(Outcome.Exile, player.getId(), source, game)) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
            return player.moveCardsToExile(new CardsImpl((Collection)target.getTargets()).getCards(game), source, game, true, exileId, sourceObject.getIdName());
        }
        return false;
    }

    public KarnPlayerExileEffect copy() {
        return new KarnPlayerExileEffect(this);
    }
}

