/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.target.Target;

class KarnsTemporalSunderingEffect
extends OneShotEffect {
    KarnsTemporalSunderingEffect() {
        super(Outcome.ExtraTurn);
        this.staticText = "Target player takes an extra turn after this one. Return up to one target nonland permanent to its owner's hand";
    }

    private KarnsTemporalSunderingEffect(KarnsTemporalSunderingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent returnPermanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (source.getTargets().getFirstTarget() != null) {
            game.getState().getTurnMods().add(new TurnMod(source.getTargets().getFirstTarget()).withExtraTurn());
        }
        if ((returnPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            controller.moveCards((Card)returnPermanent, Zone.HAND, source, game);
        }
        return true;
    }

    public KarnsTemporalSunderingEffect copy() {
        return new KarnsTemporalSunderingEffect(this);
    }
}

