/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class KastralTheWindcrestedEffect
extends OneShotEffect {
    public static final FilterCreatureCard filter = new FilterCreatureCard("Bird");

    public KastralTheWindcrestedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "You may put a Bird creature card from your hand or graveyard onto the battlefield with a finality counter on it.";
    }

    protected KastralTheWindcrestedEffect(KastralTheWindcrestedEffect effect) {
        super((OneShotEffect)effect);
    }

    public KastralTheWindcrestedEffect copy() {
        return new KastralTheWindcrestedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getHand().getCards((FilterCard)filter, source.getControllerId(), source, game));
        cards.addAllCards((Collection)controller.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(1, 1, Zone.ALL, (FilterCard)filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        for (UUID targetId : target.getTargets()) {
            game.setEnterWithCounters(targetId, new Counters(new Counter[0]).addCounter(CounterType.FINALITY.createInstance()));
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.BIRD.getPredicate());
    }
}

