/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

enum KateStewartValue implements DynamicValue
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, sourceAbility.getControllerId(), sourceAbility, game).stream().map(permanent -> permanent.getCounters(game)).mapToInt(c -> c.getCount(CounterType.TIME)).sum();
    }

    public KateStewartValue copy() {
        return this;
    }

    public String getMessage() {
        return "the number of time counters among permanents you control";
    }

    public String toString() {
        return "X";
    }

    static {
        hint = new ValueHint("Time counters among permanents you control", (DynamicValue)instance);
    }
}

